#include "tecella_helper_widgets.h"

#include <QThread>
#include <QProgressDialog>

//**************************************************************************
// display_qthread_progress_estimate
//**************************************************************************
//This function displays a progress estimate for something we expect to take
// a constant amount of time, but for which we have no feedback on regarding
// actual progress.
//If the estimated time is reached, the estimate is increased by 50%.
void display_qthread_progress_estimate(QWidget *parent, QString title,
				       QThread *thread, double estimated_seconds )
{
	//convert to milliseconds
	int total = estimated_seconds * 10;

	//make sure multiplying by 1.5 actually increases the total.
	if( total < 2 ) { total = 2; }

	//create progress dialog
	QProgressDialog progress( title, "", 0, total, parent);
	progress.setWindowModality(Qt::WindowModal);
	progress.setCancelButton(0);
	progress.setMinimumDuration( 100 );

	//update progress dialog until thread has completed
	int i = 0;
	do {
		progress.setValue(i++);


		//If we've reached 100% already, the estimated time was too short
		//Increase total estimated time by 50%.
		if(i==total) {
			total *= 1.5;
			progress.setMaximum(total);
		}
	} while( !thread->wait(100) );

	//all done
	progress.setValue( total );
	return;
}
