#include <QtGui/QApplication>
#include <QTabWidget>

#include "00_toplevel_example.h"
#include "amplifier_settings.h"
#include "channel_settings.h"

#include "TecellaAmp.h"



int main(int argc, char *argv[])
{
	QApplication a(argc, argv);
	TopLevelExample w;
	w.show();

	return a.exec();
}

TopLevelExample::TopLevelExample(QWidget *parent)
	: QMainWindow(parent), amp_handle(-1)
{
	//initializes the first available device
	if( tecella_initialize(&amp_handle) != TECELLA_ERR_OK )
	{
		setCentralWidget( new QLabel("Error: No amplifier found.", this) );
	}
	else
	{
		AmplifierSettings *amp_settings = new AmplifierSettings(this, amp_handle);

		ChannelSettings *channel_settings = new ChannelSettings(this);
		channel_settings->setAmpHandle(amp_handle);

		QTabWidget *top = new QTabWidget(this);
		top->addTab(amp_settings, "Amplifier");
		top->addTab(channel_settings, "Channel");

		setCentralWidget(top);
	}
}

TopLevelExample::~TopLevelExample()
{
}
