/*******************************************************************************
Copyright (c) 2010 Tecella LLC
Licensed under the MIT License
*******************************************************************************/

#ifndef ACQUISITION_INTERRUPTER_H
#define ACQUISITION_INTERRUPTER_H

//If you would like to allow the channel settings to interrupt
// a repeat acquisition, create a class that implements this interface
class AcquisitionInterrupter
{
public:
	//if wait=true, pause_acquisition should block until the acquisition has been paused.
	virtual bool pause_acquisition(bool wait) = 0;

	//if wait=true, pause_acquisition should block until the acquisition has been resumed.
	virtual bool resume_acquisition(bool wait) = 0;
};

#endif // ACQUISITION_INTERRUPTER_H
