/*******************************************************************************
Copyright (c) 2010 Tecella LLC
Licensed under the MIT License
*******************************************************************************/

#ifndef SYSTEM_MONITOR_H
#define SYSTEM_MONITOR_H

#include <QDialog>
#include <QTableWidget>
#include <QHeaderView>
#include <QTimer>

#include "TecellaAmp.h"

namespace Ui {
	class SystemMonitor;
}

class SystemMonitor : public QDialog {
	Q_OBJECT
public:
	SystemMonitor(TECELLA_HNDL h, QWidget *parent = 0);
	~SystemMonitor();

public slots:
	void updateTimerInterval(int ms);
	void update();

protected:
	void changeEvent(QEvent *e);

private:
	Ui::SystemMonitor *ui;
	TECELLA_HNDL h;
	QTimer timer;
};

class QSystemMonitorTable : public QTableWidget {
	Q_OBJECT
public:
	QSystemMonitorTable(QWidget *parent=0) : QTableWidget(parent) {}

public slots:
	void adjustCellSizes()
	{
		//Adjust width
		resizeColumnsToContents();
		int available = viewport()->width();
		for ( int col = 0; col < columnCount(); ++col ) {
			available -= columnWidth( col );
		}
		if(available>0 && columnCount()>0 )
		{
			int perColumn = available / columnCount();
			int leftover = available % columnCount();
			for ( int col = 0; col < columnCount(); ++col ) {
				setColumnWidth( col, columnWidth( col ) + perColumn + ((col<leftover)?1:0) );
			}
		}

		//Adjust height
		resizeRowsToContents();
		float ideal_size = 0;
		ideal_size = horizontalHeader()->height();
		for( int row=0; row < rowCount(); ++row ) {
			ideal_size += rowHeight(row);
		}
		setMaximumHeight(ideal_size+2);
	}

	void resizeEvent( QResizeEvent* event )
	{
		adjustCellSizes();
		QTableView::resizeEvent( event );
	}
};

#endif // SYSTEM_MONITOR_H
