/*******************************************************************************
Copyright (c) 2010 Tecella LLC
Licensed under the MIT License
*******************************************************************************/

#ifndef __CHANNEL_SETTINGS__
#define __CHANNEL_SETTINGS__

#include "ui_channel_settings.h"

#include <vector>

#include <QWidget>
#include <QThread>

#include "TecellaAmp.h"

class AcquisitionInterrupter;


class ChannelSettings : public QWidget
{
Q_OBJECT
public:
	ChannelSettings(QWidget *parent);
	void setAmpHandle( TECELLA_HNDL amp_handle_new );
	void setAcquisitionInterrupter( AcquisitionInterrupter *acquisition_interrupter_new );

public slots:
	void acquisitionHint(bool acquiring);

	void updateUI(); //updates the UI to reflect the values of the amplifier

	void selectedChannelsChanged(std::vector<int> &selected_channels_new);

	void selectSource(int index);
	void selectGain(int index);
	void selectGain1(int index);
	void selectGain2(int index);
	void selectStimulus(int index);

	bool pauseAcquisition();
	bool resumeAcquisition();

	void doAutoOffset();
	void doAutoLeak();
	void doAutoCapacitance();
	void doAutoArtifact(bool enable);
	void doAutoCapAndArt();
	void selectOffsetAdjustMode(int index);
	
	void enableReg(TECELLA_REGISTER reg, bool enabled);
	void enableLeak(bool enabled);
	void enableLeakD(bool enabled);
	void enableRSeries(bool enabled);
	void enableJP(bool enabled);
	void enableJPFine(bool enabled);
        void enableVhalf(bool enabled);
        void enableBessel(bool enabled);
	void enableCFast(bool enabled);
	void enableCSlowA(bool enabled);
	void enableCSlowB(bool enabled);
	void enableCSlowC(bool enabled);
	void enableCSlowD(bool enabled);
	void enableArtifact(bool enabled);
	
	//Slider versions
	void setLeak(int value);
	void setLeakFine(int value);
	void setLeakD(int value);
	void setRSeries(int value);
	void setJP(int value);
	void setJPFine(int value);
        void setVhalf(int value);
        void setIcmdOffset(int value);
	void setBessel(int value);
	void setCFast(int value);
	void setCSlowA(int value);
	void setCSlowB(int value);
	void setCSlowC(int value);
	void setCSlowD(int value);
	void setHPF(int value);
	void setBoostFrequency(int value);
	void setBoostGain(int value);
	
	//SpinBox versions
	void setReg(TECELLA_REGISTER reg, double value);
	void setLeak(double value);
	void setLeakFine(double value);
	void setLeakD(double value);
	void setRSeries(double value);
	void setJP(double value);
	void setJPFine(double value);
        void setVhalf(double value);
        void setIcmdOffset(double value);
	void setCFast(double value);
	void setCSlowA(double value);
	void setCSlowB(double value);
	void setCSlowC(double value);
	void setCSlowD(double value);
	void setHPF(double value);
	void setBoostFrequency(double value);
	void setBoostGain(double value);

	//Dynamic stimulus controls
	void zapDurationChanged(int duration);
	void useZapPulse(bool enable);
	void doZap(bool toggle);

private:
	friend class FlowFreestyle;

	AcquisitionInterrupter *acquisition_interrupter;

	Ui::ChannelSettings ui;

	TECELLA_HNDL amp_handle;
	TECELLA_HW_PROPS hwprops;
	TECELLA_HW_PROPS_EX_01 hwprops_ex_01;

	bool updatingUI;
	std::vector<int> selected_channels;
	double digital_leak_display_scale;
	double digital_leak_min;
	double digital_leak_max;
	double digital_leak_lsb;
	int digital_leak_steps;
	int digital_leak_precision;

private slots:
	void on_checkBox_EnableFreqBoost_toggled(bool checked);
        void on_checkBox_EnableVcmd_toggled(bool checked);
        void on_checkBox_EnableRs100_toggled(bool checked);  // Rs100
        void on_checkBox_IclampOn_toggled(bool checked);    // IclampOn
	void on_groupBox_CompensationDetail_toggled(bool );
	void on_groupBox_CompensationAuto_toggled(bool );
	void on_groupBox_General_toggled(bool );
	void on_PushButton_AutoArtifact_clicked();
	void on_pushButton_ZeroArtifact_clicked();
	void on_pushButton_ZeroCapacitance_clicked();
	void on_pushButton_ZeroLeak_clicked();
	void on_pushButton_ZeroJP_clicked();
};

#endif //#ifndef __CHANNEL_SETTINGS__
