#include "channel_selector.h"

#include <QtGui>
#include <QApplication>
#include <QMessageBox>

ChannelSelector::ChannelSelector(QWidget *parent)
: QWidget(parent)
{
	ui.setupUi(this);
	QObject::connect( ui.listWidget_Channels, SIGNAL(itemSelectionChanged()),
		this, SLOT(selectionChanged()) );
	QObject::connect( ui.pushButton_All, SIGNAL(pressed()), this, SLOT(selectAll()) );
}

void ChannelSelector::setChannelCount(int channel_count)
{
    ui.listWidget_Channels->clear();

    for(int i=0; i<channel_count; i++) {
	    QListWidgetItem *new_item = new QListWidgetItem();
	    new_item->setText( QString::number(i+1) );
	    new_item->setTextAlignment( Qt::AlignRight | Qt::AlignVCenter );
	    new_item->setFont( QFont("Courier New",10) );
	    ui.listWidget_Channels->addItem(new_item);
    }
}

void ChannelSelector::selectionChanged()
{
	selected_channels.clear();

	QList<QModelIndex> selected_items = ui.listWidget_Channels->selectionModel()->selectedRows();

	for (int i = 0; i < selected_items.size(); i++) {
		selected_channels.push_back(
			selected_items[i].row() );
	}

	emit selectedChannelsChanged(selected_channels);
}

void ChannelSelector::selectAll()
{
	ui.listWidget_Channels->selectAll();
}

