#ifndef AUTO_CALIBRATION_THREADS_H
#define AUTO_CALIBRATION_THREADS_H

#include <QThread>
#include "TecellaAmp.h"

class AutoCalibrateThread : public QThread
{
public:
	AutoCalibrateThread(TECELLA_HNDL amp_handle, bool enable) : amp_handle(amp_handle), enable(enable) {}
	void run()
	{
		tecella_calibrate_all(amp_handle);
		tecella_calibrate_save(amp_handle, ".", 0);
	}

private:
	TECELLA_HNDL amp_handle;
	bool enable;
};

class AutoCalibrateCurrentThread : public QThread
{
public:
	AutoCalibrateCurrentThread(TECELLA_HNDL amp_handle, bool enable) : amp_handle(amp_handle), enable(enable) {}
	void run()
	{
		tecella_auto_calibrate(amp_handle, true, 0);
		tecella_auto_scale(amp_handle, true, 0);
		tecella_calibrate_save(amp_handle, ".", 0);
	}

private:
	TECELLA_HNDL amp_handle;
	bool enable;
};

#endif // AUTO_CALIBRATION_THREADS_H
