/*******************************************************************************
Copyright (c) 2010 Tecella LLC
Licensed under the MIT License
*******************************************************************************/

#ifndef TC_UTILITY_SHARED_H
#define TC_UTILITY_SHARED_H

#include <string>

namespace tcu
{

//Does a dumb copy from a std::wstring to a std::string
std::string wstr2str(const std::wstring &src);

//structure to represent metric bases and conversions
struct MetricBase
{
	double base;
	std::string prefix;

	MetricBase(double base, std::string prefix);

	static MetricBase bestBase(double n);
};


} //namespace tcu

#endif // TC_UTILITY_SHARED_H
