/*******************************************************************************
Copyright (c) 2010 Tecella LLC
Licensed under the MIT License
*******************************************************************************/

#ifndef AMPLIFIER_SETTINGS_H
#define AMPLIFIER_SETTINGS_H

#include <QWidget>
#include "TecellaAmp.h"

class AcquisitionInterrupter;

namespace Ui {
	class AmplifierSettings;
}

class AmplifierSettings : public QWidget {
	Q_OBJECT
public:
	AmplifierSettings(QWidget *parent, TECELLA_HNDL amp_handle_new );
	~AmplifierSettings();

	void setAmpHandle( TECELLA_HNDL amp_handle_new );
	void setAcquisitionInterrupter( AcquisitionInterrupter *acquisition_interrupter_new );

	bool pauseAcquisition();
	bool resumeAcquisition();

	void doAutoCalibrate(bool enable);
	void doAutoCalibrateCurrent(bool enable);
	void showCalibrateScale(bool enable);

public slots:
	void acquisitionHint(bool acquiring);

signals:
	void ampOrConfigChanged();

protected:
	void changeEvent(QEvent *e);

private:
	bool updatingUI;
	Ui::AmplifierSettings *ui;

	AcquisitionInterrupter *acquisition_interrupter;
	TECELLA_HNDL amp_handle;

private slots:
	void on_pushButton_CalibrateCurrentConfig_clicked();
	void on_pushButton_CalibrateAll_clicked();
	void on_checkBox_EnableScaleCalibration_toggled(bool checked);
	void on_checkBox_EnableOffsetCalibration_toggled(bool checked);
	void on_doubleSpinBox_UDac1_valueChanged(double );
	void on_doubleSpinBox_UDac2_valueChanged(double );
	void on_doubleSpinBox_UDac3_valueChanged(double );
	void on_doubleSpinBox_UDac4_valueChanged(double );
	void on_comboBox_SystemMonitorIndex_currentIndexChanged(int index);
	void on_pushButton_SystemMonitor_clicked();
	void on_comboBox_Configuration_currentIndexChanged(int index);
};

#endif // AMPLIFIER_SETTINGS_H
