/*******************************************************************************
Copyright (c) 2010 Tecella LLC
Licensed under the MIT License
*******************************************************************************/

#ifndef TECELLA_HELPER_WIDGETS_H
#define TECELLA_HELPER_WIDGETS_H

#include <QFrame>
#include <QSpinBox>

#include "TecellaAmp.h"

class QThread;

//**************************************************************************
// QShadowFrame
//**************************************************************************
// QShadowFrame exists as a way to use stylesheets on a frame
// without it cascading down to all it's children that have or are
// considered QFrame's also.
class TecellaShadowFrame : public QFrame
{
	Q_OBJECT
public:
	TecellaShadowFrame(QWidget *parent = 0) : QFrame(parent) {}
};

//**************************************************************************
// TecellaBesselSpinBox
//**************************************************************************
// Bessel scale is non-linear and requires a unique spin box
class TecellaBesselSpinBox : public QSpinBox
{
private:
	TECELLA_HNDL ampHandle;

public:
	TecellaBesselSpinBox(QWidget *parent)
	: QSpinBox(parent)
	{
		ampHandle = -1;
	}

	void setTecellaHandle(TECELLA_HNDL ampHandle)
	{
		this->ampHandle = ampHandle;
		TECELLA_HW_PROPS hw_props;
		tecella_get_hw_props(ampHandle, &hw_props);

		setRange( hw_props.bessel_value_min, hw_props.bessel_value_max );
	}

	QString textFromValue ( int value ) const
	{
		if(ampHandle<0) return "N/A";

		double d_value;
		tecella_bessel_value2freq(ampHandle, value, &d_value);
		return QString::number(d_value);
	}

	int valueFromText ( const QString & text ) const
	{
		if(ampHandle<0) return 0;

		int value;
		tecella_bessel_freq2value(ampHandle, text.toDouble(), &value);
		return value;
	}
};


//**************************************************************************
// display_qthread_progress_estimate
//**************************************************************************
//This function displays a progress estimate for something we expect to take
// a constant amount of time, but for which we have no feedback on regarding
// actual progress.
//If the estimated time is reached, the estimate is increased by 50%.
void display_qthread_progress_estimate(QWidget *parent, QString title,
				       QThread *thread, double estimated_seconds );


#endif // TECELLA_HELPER_WIDGETS_H
